//******************************************************************************
// Doppler.java:	Applet
//
//******************************************************************************
import java.applet.*;
import java.awt.*;
import java.util.*;
import DopplerFrame;
import Generation;

//==============================================================================
// Main Class for applet Doppler
//
//==============================================================================
public class Doppler extends Applet implements Runnable
{
	// THREAD SUPPORT:
	//		m_Doppler	is the Thread object for the applet
	//--------------------------------------------------------------------------
	Thread	 m_Doppler = null;
	private Scrollbar speedBar;
	private Label speedLabel;
	private DopplerCanvas dc;

	//--------------------------------------------------------------------------
	private Graphics m_Graphics;

	// STANDALONE APPLICATION SUPPORT:
	//		m_fStandAlone will be set to true if applet is run standalone
	//--------------------------------------------------------------------------
	boolean m_fStandAlone = false;

	// PARAMETER SUPPORT:
	//		Parameters allow an HTML author to pass information to the applet;
	// the HTML author specifies them using the <PARAM> tag within the <APPLET>
	// tag.  The following variables are used to store the values of the
	// parameters.
    //--------------------------------------------------------------------------

    // Members for applet parameters
    // <type>       <MemberVar>    = <Default Value>
    //--------------------------------------------------------------------------
	private double m_speed = 0.5;

    // Parameter names.  To change a name of a parameter, you need only make
	// a single change.  Simply modify the value of the parameter string below.
    //--------------------------------------------------------------------------
	private final String PARAM_speed = "speed";

	// STANDALONE APPLICATION SUPPORT
	// 	The GetParameter() method is a replacement for the getParameter() method
	// defined by Applet. This method returns the value of the specified parameter;
	// unlike the original getParameter() method, this method works when the applet
	// is run as a standalone application, as well as when run within an HTML page.
	// This method is called by GetParameters().
	//---------------------------------------------------------------------------
	String GetParameter(String strName, String args[])
	{
		if (args == null)
		{
			// Running within an HTML page, so call original getParameter().
			//-------------------------------------------------------------------
			return getParameter(strName);
		}

		// Running as standalone application, so parameter values are obtained from
		// the command line. The user specifies them as follows:
		//
		//	JView Doppler param1=<val> param2=<"val with spaces"> ...
		//-----------------------------------------------------------------------
		int    i;
		String strArg	= strName + "=";
		String strValue = null;

		for (i = 0; i < args.length; i++)
		{
			if (strArg.equalsIgnoreCase(args[i].substring(0, strArg.length())))
			{
				// Found matching parameter on command line, so extract its value.
				// If in double quotes, remove the quotes.
				//---------------------------------------------------------------
				strValue= args[i].substring(strArg.length());
				if (strValue.startsWith("\""))
				{
					strValue = strValue.substring(1);
					if (strValue.endsWith("\""))
						strValue = strValue.substring(0, strValue.length() - 1);
				}
			}
		}

		return strValue;
	}

	// STANDALONE APPLICATION SUPPORT
	// 	The GetParameters() method retrieves the values of each of the applet's
	// parameters and stores them in variables. This method works both when the
	// applet is run as a standalone application and when it's run within an HTML
	// page.  When the applet is run as a standalone application, this method is
	// called by the main() method, which passes it the command-line arguments.
	// When the applet is run within an HTML page, this method is called by the
	// init() method with args == null.
	//---------------------------------------------------------------------------
	void GetParameters(String args[])
	{
		// Query values of all Parameters
		//--------------------------------------------------------------
		String param;

		// speed: Source Speed
		//--------------------------------------------------------------
		param = GetParameter(PARAM_speed, args);
		if (param != null)
			m_speed = Double.valueOf(param).doubleValue();

	}

	// STANDALONE APPLICATION SUPPORT
	// 	The main() method acts as the applet's entry point when it is run
	// as a standalone application. It is ignored if the applet is run from
	// within an HTML page.
	//--------------------------------------------------------------------------
	public static void main(String args[])
	{
		// Create Toplevel Window to contain applet Doppler
		//----------------------------------------------------------------------
		DopplerFrame frame = new DopplerFrame("Doppler");

		// Must show Frame before we size it so insets() will return valid values
		//----------------------------------------------------------------------
		frame.show();
        frame.hide();
		frame.resize(frame.insets().left + frame.insets().right  + 320,
					 frame.insets().top  + frame.insets().bottom + 240);

		// The following code starts the applet running within the frame window.
		// It also calls GetParameters() to retrieve parameter values from the
		// command line, and sets m_fStandAlone to true to prevent init() from
		// trying to get them from the HTML page.
		//----------------------------------------------------------------------
		Doppler applet_Doppler = new Doppler();

		frame.add("Center", applet_Doppler);
		applet_Doppler.m_fStandAlone = true;
		applet_Doppler.GetParameters(args);
		applet_Doppler.init();
		applet_Doppler.start();
        frame.show();
	}

	public boolean handleEvent(Event evt)
	{
		if (evt.id==Event.SCROLL_ABSOLUTE
		       ||evt.id==Event.SCROLL_LINE_DOWN
			   ||evt.id==Event.SCROLL_LINE_UP
			   ||evt.id==Event.SCROLL_PAGE_DOWN
			   ||evt.id==Event.SCROLL_PAGE_UP)
		{
			speedLabel.setText("V="+speedBar.getValue()/100.0);
			m_speed=speedBar.getValue()/100.0;
			dc.setSpeed(m_speed,0);
			return true;
		}
	  return super.handleEvent(evt);
	}


	// Doppler Class Constructor
	//--------------------------------------------------------------------------
	public Doppler()  //Add constructor code here
	{

		
	}

	// APPLET INFO SUPPORT:
	//		The getAppletInfo() method returns a string describing the applet's
	// author, copyright date, or miscellaneous information.
    //--------------------------------------------------------------------------
	public String getAppletInfo()
	{
		return "Name: Doppler\r\n" +
		       "Author: Wolfgang Christian\r\n" +
		       "Beta";
	}

	// PARAMETER SUPPORT
	//		The getParameterInfo() method returns an array of strings describing
	// the parameters understood by this applet.
	//
    // Doppler Parameter Information:
    //  { "Name", "Type", "Description" },
    //--------------------------------------------------------------------------
	public String[][] getParameterInfo()
	{
		String[][] info =
		{
			{ PARAM_speed, "double", "Source Speed" },
		};
		return info;		
	}

	// The init() method is called by the AWT when an applet is first loaded or
	// reloaded.  Override this method to perform whatever initialization your
	// applet needs, such as initializing data structures, loading images or
	// fonts, creating frame windows, setting the layout manager, or adding UI
	// components.
    //--------------------------------------------------------------------------
	public void init()
	{
		if (!m_fStandAlone)
			GetParameters(null);
        // If you use a ResourceWizard-generated "control creator" class to
        // arrange controls in your applet, you may want to call its
        // CreateControls() method from within this method. Remove the following
        // call to resize() before adding the call to CreateControls();
        // CreateControls() does its own resizing.
        //----------------------------------------------------------------------
		resize(320, 240);
		setLayout (new BorderLayout());
		Panel p= new Panel();
		p.setLayout(new GridLayout(1,2));
		p.add(speedBar=new Scrollbar(Scrollbar.HORIZONTAL,(int)(100*m_speed),4,0,100));
		p.add(speedLabel=new Label("  V= "+m_speed));
		p.setBackground(Color.lightGray);
		//p.insets().top=6;		why doesn't this work?
		//p.insets().bottom=6;	
		add("South",p);
		dc= new DopplerCanvas();
		dc.setBackground(Color.white);
		add("Center",dc);
		dc.setSpeed(m_speed,0);


		// TODO: Place additional initialization code here
	}

	// Place additional applet clean up code here.  destroy() is called when
	// when you applet is terminating and being unloaded.
	//-------------------------------------------------------------------------
	public void destroy()
	{
		// TODO: Place applet cleanup code here
		if(m_Doppler != null) 
		{
			m_Doppler.stop();
			m_Doppler=null;
		}
	}


	//		The start() method is called when the page containing the applet
	// first appears on the screen. The AppletWizard's initial implementation
	// of this method starts execution of the applet's thread.
	//--------------------------------------------------------------------------
	public void start()
	{
		if (m_Doppler == null)
		{
			dc.resetSource();
			m_Doppler = new Thread(this);
			m_Doppler.start();
		}
		// TODO: Place additional applet start code here
	}
	
	//		The stop() method is called when the page containing the applet is
	// no longer on the screen. The AppletWizard's initial implementation of
	// this method stops execution of the applet's thread.
	//--------------------------------------------------------------------------
	public void stop()
	{
		if (m_Doppler != null)
		{
			m_Doppler.stop();
			m_Doppler = null;
		}

		// TODO: Place additional applet stop code here
	}

	// THREAD SUPPORT
	//		The run() method is called when the applet's thread is started. If
	// your applet performs any ongoing activities without waiting for user
	// input, the code for implementing that behavior typically goes here. For
	// example, for an applet that performs animation, the run() method controls
	// the display of images.
	//--------------------------------------------------------------------------
	public void run()
	{
		while (true)
		{
			try
			{
				dc.incTime();
				dc.repaint();
				// TODO:  Add additional thread-specific code here
				Thread.sleep(50);
			}
			catch (InterruptedException e)
			{
				// TODO: Place exception-handling code here in case an
				//       InterruptedException is thrown by Thread.sleep(),
				//		 meaning that another thread has interrupted this one
				stop();
			}
		}
	}


}

//Drawing methods
class DopplerCanvas extends Canvas
{
	
	public DopplerCanvas() // constructor for Canvas
	{


	}

	public void resetSource()
	{
		xs=0;
		ys=size().height/ 2;
		time=0;
	}

	public void setSpeed(double vx_, double vy_)
	{
		vxs=vx_; vys=vy_;
	}

	public void incTime()
	{
		time++;
		xs=(xs+vxs);
		if(xs>size().width) resetSource();
		if (time%10==0)
		{
			if(genVec.size()>10) genVec.removeElementAt(0);
			genVec.addElement(new Generation(time,(int)xs,(int)ys,vxs,vxs));
		}
	}

	private void calcBuffImage()
	{
		int i;
		int len=genVec.size();	//length of vector
		Graphics g=buff_image.getGraphics();
		Generation gen;
		g.clearRect(0,0,buff_width,buff_height);
		// Draw source in center of applet
		//----------------------------------------------------------------------
		g.fillOval((int)(xs-2),(int)(ys-2),4,4);
		if(len>0)for(i=0; i<len;i++)
		{
			g.setColor(new Color(255*(len-i)/len,255*(len-i)/len,255*(len-i)/len));
			gen=(Generation)(genVec.elementAt(i));
			gen.draw(time, g);
		}
		// g.setColor(Color.black);
		g.dispose();
	}

	public void update(Graphics g)
	{ 
		paint(g); //update usually does a rect fill with a background color.  We don't need this.
	}


	// Doppler Paint Handler
	//--------------------------------------------------------------------------
	public void paint(Graphics g)
	{		
		if (size().width!=buff_width||size().height!=buff_height)
		{
			ys=size().height/ 2;
			buff_width=size().width;
			buff_height=size().height;
			buff_image=createImage(buff_width,buff_height);
		}
		calcBuffImage();
		g.drawImage(buff_image,0,0,this);
		// g.drawString("Position= "+xs/size().width, 10, 20);
	}

	private double xs,ys;		// source position;
	private double vxs,vys;		// source velocity;
	private Vector genVec= new Vector();
	private int time=0;		// running time
	private Image buff_image=null;
	private int buff_width=0;
	private int buff_height=0;



}
