// Copyright 1996 BDM International, Inc.  This applet and associated
// documentation and files may be distributed in its entirety for
// non-commercial purposes only, provided this copyright notice is included 
// in every copy made.  All other rights reserved by the author. 

// This applet and associated documentation and files are provided "as is" 
// with no warranty of any kind, either expressed or implied, including, but
// not lmited to the implied warranties of merchantability, fitness for a
// particular purpose, and non-infringement.

// Programmer: Kelly Jo Brown

import java.awt.*;
import java.applet.*;
import java.lang.*;

public class orbit2 extends java.applet.Applet implements Runnable{
   Graphics img;
   Image screen,earth,satelite,title,bar,parea;
   int starsx[];
   int starsy[];
   int pause=50,percent=10;
   int px,py,tempx,tempy,area_points=0;
   double angle=0.0,e=.8,time=0,delta_time=.2;
   int areax[]=new int[212];
   int areay[]=new int[212];
   Thread kicker = null;
   MediaTracker tracker;

   public void run() 
   {
      double rad,delta_angle,radius;
      int i;
    
      Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
      while(kicker != null) 
      {
         // Convert angle to radians
         rad=angle*Math.PI/180;
         // Calculate Radius
         radius=(1-e*e)/(1-e*Math.cos(rad));
         // Calculate angle delta
         delta_angle=2*Math.PI*Math.sqrt(1-e*e)/(radius*radius)*delta_time;
         // Add deltas
         time=time+delta_time;
         angle=angle+delta_angle;
         rad=angle*Math.PI/180;
         // Calculate Coordinates
         px=(int) (90*radius*Math.cos(rad));
         py=(int) (90*radius*Math.sin(rad));
         for(i=area_points;i>0;i--)
         {
           areax[i+1]=areax[i];
           areay[i+1]=areay[i];
         }
         if(area_points<(percent*7))
            area_points++;
         if(area_points>(percent*7)) 
            area_points=percent*7;
         areax[1]=px+110;
         areay[1]=py+150;
         //areax[area_points]=px+110;
         //areay[area_points]=py+150;
         repaint();
         try {Thread.sleep(pause);} catch (InterruptedException e){};
      }
   }
	
   public void init()
   {
      int i;

      starsx=new int[40];
      starsy=new int[40];
      for(i=0;i<40;i++)
      {
         starsx[i]=(int)Math.round(Math.random()*300);
         starsy[i]=(int)Math.round(Math.random()*300);
      }
      // Load images
      earth=getImage(getDocumentBase(),"graphics/earth.gif");
      satelite=getImage(getDocumentBase(),"graphics/sat.gif");
      title=getImage(getDocumentBase(),"graphics/kepler_2.gif");
      bar=getImage(getDocumentBase(),"graphics/percent_slid.gif");
      parea=getImage(getDocumentBase(),"graphics/percent_b.gif");
      // Add tracker to see if images loaded
      tracker = new MediaTracker(this);
      tracker.addImage(earth,0);
      tracker.addImage(satelite,0);
      tracker.addImage(title,0);
      tracker.addImage(bar,0);
      tracker.addImage(parea,0);
      areax[0]=110;
      areay[0]=150;
   }

   public void start() 
   {
      if(kicker == null) 
      {
         kicker = new Thread(this);
	kicker.start();
      }
   }

   public void stop() 
   {
      kicker = null;
   }

   public boolean mouseDown(Event evt, int x, int y)
   {
      if(x<300)
      {
         if(kicker==null)
            start();
         else
            kicker=null;
      }
      // Clicked on slidebar, slide it
      if(x>345 && x<405 && y>99 && y<200)
      {
         percent=(int)((200-y)/3.33);
      }
      return true;
   }

   public boolean mouseDrag(Event evt, int x, int y)
   {
      // Clicked on slidebar, slide it
      if(x>345 && x<405 && y>99 && y<200)
      {
         percent=(int)((200-y)/3.33);
      }
      return true;
   }

   public final synchronized void update(Graphics g) 
   {
      String str;
      int i;

      if(screen == null) 
      {
         screen = createImage(500,300);
         img = screen.getGraphics();
      }
      // Fill black background
      img.setColor(Color.black);
      img.fillRect(0,0,300,299);
      // Fill white background
      img.setColor(Color.white);
      img.fillRect(300,0,499,299);
      if(tracker.statusID(0,true)!=MediaTracker.COMPLETE)
      {
         img.drawString("Please Wait Loading Graphics",20,160);
      }
      else
      {
         // Draw title
         img.drawImage(title,302,0,this);
         // Draw star field
         img.setColor(Color.white);
         for(i=0;i<40;i++)
         {
            img.drawLine(starsx[i],starsy[i],starsx[i],starsy[i]);
         }
         // Draw Earth
         img.drawImage(earth,100,140,this);
         // Draw Area
         img.setColor(Color.yellow);
         img.fillPolygon(areax,areay,area_points);
         // Draw satelite
         img.drawImage(satelite,px+105,py+145,this);
         // Draw Slide Bar
         img.drawImage(bar,341,93,this);
         img.setColor(Color.yellow);
         img.fillRect(351,200-(int)(percent*3.33),31,(int)(percent*3.33));
         // Draw percentage number of slide bar
         img.setColor(Color.black);
         img.drawString("30%",400,105);
         img.drawString("15%",400,155);
         img.drawString("0%",400,205);
         // Draw percent readout graphics and print percent 
         img.setColor(Color.black);
         img.drawImage(parea,305,265,this);
         img.drawString(" "+percent+"%",415,285);
      }
      paint(img);
      g.drawImage(screen,0,0,null);
   }
}









