// Copyright 1996 BDM International, Inc.  This applet and associated
// documentation and files may be distributed in its entirety for
// non-commercial purposes only, provided this copyright notice is included 
// in every copy made.  All other rights reserved by the author. 

// This applet and associated documentation and files are provided "as is" 
// with no warranty of any kind, either expressed or implied, including, but
// not lmited to the implied warranties of merchantability, fitness for a
// particular purpose, and non-infringement.

// Programmer: Kelly Jo Brown

import java.awt.*;
import java.applet.*;
import java.lang.*;

public class orbit3 extends java.applet.Applet implements Runnable
{
   Graphics img;
   Image screen,geo_button,satelite,title,shut_button;
   boolean done;
   int starsx[];
   int starsy[];
   int i,hours,minutes;
   int pause=100;
   int caught=0;
   int mousex=0,mousey=0;
   int px,py,distance=105;
   double rad,angle=0.0,afactor=1.0,eangle=0,checkdist;
   double period=23.94,height=35784;
   Thread kicker = null;
   Button mybutton;
   MediaTracker tracker;

   public void run() 
   {
      Thread.currentThread().setPriority(Thread.MIN_PRIORITY);
      while(kicker != null) 
      {
         angle=angle+afactor;
         angle=angle % 360;
         eangle=eangle+1;
         rad=angle*Math.PI/180;
         px =(int) (distance * Math.cos(rad));
         py =(int) (distance * Math.sin(rad));
         repaint();
         try {Thread.sleep(pause);} catch (InterruptedException e){};
      }
   }
	
   public boolean mouseDown(Event evt, int x, int y)
   {
      mousex=x;
      mousey=y;
      checkdist=Math.sqrt((x-150)*(x-150)+(y-150)*(y-150));
      // Clicked inside space, grab satelite
      if(checkdist<140 && checkdist>16)
      {
         caught=1;
         stop();
         px=x-150;
         py=y-150;
         repaint();
      }
      // Clicked on geosync button
      if(x>315 && x<450 && y>220 && y<250)
      {   
         distance=105;
         afactor=1.0;
         height=35784;
         period=23.94;
      }
      // Clicked on shuttle  button
      if(x>315 && x<450 && y>260 && y<290)
      {   
         distance=20;
         afactor=16.0;
         height=240;
         period=1.5;
      }
      return true;
   }

   public boolean mouseDrag(Event evt, int x, int y)
   {
      mousex=x;
      mousey=y;
      // Have satelite follow mouse if caught
      if(caught==1)
      {
         checkdist=Math.sqrt((x-150)*(x-150)+(y-150)*(y-150));
         if(checkdist<140 && checkdist>16)
         {
            px=x-150;
            py=y-150;
            repaint();
         }
      }
      return true;
   }

   public boolean mouseUp(Event evt, int x, int y)
   {
      mousex=x;
      mousey=y;

      // Drop the satelite and calculate orbit
      if(caught==1)
      {
         checkdist=Math.sqrt((x-150)*(x-150)+(y-150)*(y-150));
         if(checkdist<140 && checkdist>16)
         {
            px=x-150;
            py=y-150;
         }
         distance=(int) Math.sqrt((double)(px*px+py*py));
         angle=(int) (Math.atan2((py),(px)) * 180/Math.PI);
         if(angle<0) angle+=360;
         afactor=360.0/Math.sqrt(distance*distance*distance)*2.988694;
         height=distance*42162/105;
         period=24/afactor;
         height=height-6378;
         caught=0;
         start();
         repaint();
      }
      return true;
   }

   public void init()
   {
      /* set up star map */
      starsx=new int[60];
      starsy=new int[60];
      for(i=0;i<60;i++)
      {
         starsx[i]=(int)Math.round(Math.random()*300);
         starsy[i]=(int)Math.round(Math.random()*300);
      }
      /* load graphics */
      geo_button=getImage(getDocumentBase(),"graphics/GeoButton.gif");
      satelite=getImage(getDocumentBase(),"graphics/Sat.gif");
      title=getImage(getDocumentBase(),"graphics/kepler_3.gif");
      shut_button=getImage(getDocumentBase(),"graphics/ShutButton.gif");
      // Add tracker to see if images loaded
      tracker = new MediaTracker(this);
      tracker.addImage(geo_button,0);
      tracker.addImage(satelite,0);
      tracker.addImage(title,0);
      tracker.addImage(shut_button,0);
   }

   public void start() 
   {
      if(kicker == null) 
      {
         kicker = new Thread(this);
	kicker.start();
      }
   }

   public void stop() 
   {
      kicker = null;
   }


   public final synchronized void update(Graphics g) 
   {
      String str,before,after;

      if(screen == null) 
      {
         screen = createImage(500,300);
         img = screen.getGraphics();
      }
      // Fill black background
      img.setColor(Color.black);
      img.fillRect(0,0,300,299);
      // Fill white background
      img.setColor(Color.white);
      img.fillRect(300,0,499,299);
      if(tracker.statusID(0,true)!=MediaTracker.COMPLETE)
      {
         img.drawString("Please Wait Loading Graphics",20,160);
      }
      else
      {
         // Draw title and buttons
         img.drawImage(title,302,0,this);
         img.drawImage(geo_button,315,220,this);
         img.drawImage(shut_button,315,260,this);
         // Print Data
         img.setColor(Color.black);
         if(height<1000)
            str = "Altitude= " + height + " km";
         else
         {  
            str= "" + height;
            before=str.substring(0,str.length()-3);
            after=str.substring(str.length()-3,str.length());
            str = "Altitude= " + before + "," + after + " km";
         }
         img.drawString(str,310,130);
         hours=(int)Math.floor(period);
         minutes=(int)((period-hours)*60);
         if(hours>1)
            str = "Period=" + hours + " hours " + minutes + " min";
         else
            str = "Period=" + hours + " hour " + minutes + " min";
         img.drawString(str,310,150);
         // Draw star field
         img.setColor(Color.white);
         for(i=0;i<60;i++)
         {
            img.drawLine(starsx[i],starsy[i],starsx[i],starsy[i]);
         }
         // Draw satelite
         img.drawImage(satelite,px+145,py+145,this);
         // Draw Earth
         img.setColor(Color.blue);
         img.fillArc(145,143,16,16,360-(int)eangle,180);
         img.setColor(Color.green);
         img.fillArc(145,143,16,16,180-(int)eangle,180);
      }
      paint(img);
      g.drawImage(screen,0,0,null);
   }
}







